/*
 * Decompiled with CFR 0.152.
 */
package com.category.controller;

import com.Application;
import com.category.domain.CategoryService;
import com.category.domain.model.Category;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
public class CategoryAPI {
    private final Application application;
    private final CategoryService categoryService;

    @GetMapping(value={"/PoshakProps"})
    public ResponseEntity<Map<Object, List<Map<String, Object>>>> getCategories(HttpServletRequest request) {
        if (!Application.isAccessWebService || !this.application.usePack1) {
            return null;
        }
        return this.categoryService.getCategories(request);
    }

    @PostMapping(value={"/PoshakProps"})
    public ResponseEntity<Map<String, Object>> postCategories(@RequestBody List<Category> categories) {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        return this.categoryService.postCategories(categories);
    }

    @ApiIgnore
    @PostMapping(value={"/PoshakPropsZ"})
    public ResponseEntity<?> postPoshakPropsZ(@RequestBody byte[] zippedBody) {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        return this.categoryService.postSmartHelpCategories(zippedBody);
    }

    @PutMapping(value={"/PoshakProps"})
    public ResponseEntity<Map<String, Object>> putCategories(@RequestBody List<Category> categories) {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        return this.categoryService.updateCategories(categories);
    }

    public CategoryAPI(Application application, CategoryService categoryService) {
        this.application = application;
        this.categoryService = categoryService;
    }
}

